/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIOMGT_Functionlist.h $
   Last Modification:
    $Author: Benjamin $
    $Modtime: 17.03.08 15:08 $
    $Revision: 2 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO MGT
    Task function list for configuration file

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
     2          2008-03-17  bm       changed  STARTUP_PARAM_VERSION  to 2
                                     added  ulMaxIODevCnt  to startup parameters

     1          ---         mg       initial version

**************************************************************************************/
/**
 * @file PNIOMGT_Functionlist.h
 * @brief PNIO MGT - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOMGT</code>
 * of task.
 */
#ifndef __PNM_PNIO_MGT_FUNCTIONLIST_H
#define __PNM_PNIO_MGT_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIOMGT
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIOMGT
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_MGT_STARTUP_PARAM_VERSION_V3 (3)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNM_PNIO_MGT_STARTUPPARAMETER_Ttag  PNM_PNIO_MGT_STARTUPPARAMETER_V2_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNM_PNIO_MGT_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** EDD name
   *
   * The member defines the name of Ethernet device driver, which
   * handles the access to an Ethernet port.
   */
  TLR_INT8*   pszName;
  /** maximum number of supported IO-Devices */
  TLR_UINT32  ulMaxIODevCnt;
  /** EDD instance */
  TLR_UINT    uiEddInstance;

};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNM_PNIO_MGT_FUNCTIONLIST_H */
